/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: Infobar.c,v 1.1.1.1 1999/08/08 19:38:32 heller Exp $
____________________________________________________________________________*/

#include "stdio.h"
#include "stdlib.h"
#include "windows.h"
#include "Infobar.h"

typedef struct _IB
{
	HWND hwndStatic;
	char szText[1024];
	BOOL bNormal;
	WNDPROC wpOrigProc;
	HBRUSH hBackBrush;
	HFONT hInfoFont;
	HICON hInfoIcon;
	HPEN hBorderPen;
} IB,*IBP;

COLORREF	kBlackColor			= RGB(0, 0, 0);
COLORREF	kPaleYellowColor	= RGB(255, 255, 204);

//	______________________________________
//
//  Static subclass procedure

LRESULT APIENTRY 
IBSubclassProc (
		HWND	hWnd, 
		UINT	uMsg, 
		WPARAM	wParam, 
		LPARAM	lParam) 
{
	IBP					ibp;

	ibp=(IBP)GetWindowLong (hWnd, GWL_USERDATA);
	
	switch (uMsg) 
	{
		case WM_SETTEXT:
		{
			strcpy(ibp->szText,(char *)lParam);
			// SetText seems to get rid of our subclassed WM_PAINT,
			// so return FALSE
			InvalidateRect(hWnd,NULL,TRUE);
			return FALSE;
		}

		case WM_PAINT:
		{
			if(ibp->bNormal)
				break;

			if(IsWindowVisible(hWnd))
			{
				HBRUSH hOldBackBrush;
				HFONT hOldInfoFont;
				HPEN hOldBorderPen;
				PAINTSTRUCT ps;
				HDC	hDC;
				RECT rc;
				COLORREF oldTextColor;
				COLORREF oldBkColor;
				
				GetWindowRect(hWnd,&rc);

				rc.right=rc.right-rc.left;
				rc.bottom=rc.bottom-rc.top;
				rc.top=rc.left=0;

				hDC = BeginPaint (hWnd, &ps);
				
				hOldBackBrush=SelectObject(hDC,ibp->hBackBrush);
				hOldInfoFont=SelectObject(hDC,ibp->hInfoFont);
				hOldBorderPen=SelectObject(hDC,ibp->hBorderPen);
		        oldTextColor=SetTextColor(hDC,kBlackColor);
				oldBkColor=SetBkColor(hDC,kPaleYellowColor);

				Rectangle(hDC,rc.left,rc.top,rc.right,rc.bottom);
				DrawIcon(hDC, rc.left+1-8, rc.top+2-8 ,ibp->hInfoIcon);

				rc.left=rc.left+16;
				rc.right=rc.right-2;
				rc.top=rc.top+2;
				rc.bottom=rc.bottom-2;

				ExtTextOut(hDC, rc.left, rc.top, 
					ETO_CLIPPED|ETO_OPAQUE,
					&rc, ibp->szText, lstrlen(ibp->szText), NULL);

				SelectObject(hDC,hOldBackBrush);
				SelectObject(hDC,hOldInfoFont);
				SelectObject(hDC,hOldBorderPen);
		        SetTextColor(hDC,oldTextColor);
				SetBkColor(hDC,oldBkColor);
		
				EndPaint (hWnd, &ps);
			}
			return 0;
		}
	}
    return CallWindowProc (ibp->wpOrigProc, 
		hWnd, uMsg, wParam, lParam); 
} 

VOID
IBInit(HWND hwndStatic,HICON hInfoIcon,BOOL bNormal)
{
	IBP ibp;
	LOGFONT lf;

	ibp=malloc(sizeof(IB));
	memset(ibp,0x00,sizeof(IB));
	ibp->hwndStatic=hwndStatic;

	SetWindowLong(hwndStatic,GWL_USERDATA,(LONG)ibp);

	ibp->hBackBrush=CreateSolidBrush(kPaleYellowColor);
	ibp->hBorderPen=CreatePen(PS_SOLID, 0, GetSysColor (COLOR_3DSHADOW));
	ibp->hInfoIcon=hInfoIcon;

    SystemParametersInfo (SPI_GETICONTITLELOGFONT, 
		sizeof(LOGFONT), &lf, 0);

    ibp->hInfoFont=CreateFontIndirect (&lf);

	ibp->bNormal=bNormal;

	GetWindowText(hwndStatic,ibp->szText,1024);

	ibp->wpOrigProc = (WNDPROC) 
		SetWindowLong(hwndStatic,GWL_WNDPROC,(LONG)IBSubclassProc);
}

VOID 
IBSetHighlightMode(HWND hwndStatic,BOOL bNormal)
{
	IBP ibp;

	ibp=(IBP)GetWindowLong (hwndStatic, GWL_USERDATA);

	ibp->bNormal=bNormal;
	InvalidateRect(hwndStatic,NULL,TRUE);
}

VOID 
IBDestroy(HWND hwndStatic)
{
	IBP ibp;

//	MessageBox(NULL,"DESTROYING","MYSELF",MB_OK);

	ibp=(IBP)GetWindowLong (hwndStatic, GWL_USERDATA);

	if(ibp!=0)
	{
		DeleteObject(ibp->hBackBrush);
		DeleteObject(ibp->hBorderPen);
		DeleteObject(ibp->hInfoFont);

		SetWindowLong(hwndStatic,GWL_WNDPROC,(LONG)ibp->wpOrigProc);
		SetWindowLong(hwndStatic,GWL_USERDATA,(LONG)0);

		memset(ibp,0x00,sizeof(IB));
		free(ibp);
	}
}

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/

